/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.platform;

import com.google.inject.Inject;
import info.msxlaunchers.platform.ArgumentsBuilder;
import info.msxlaunchers.platform.FileLocator;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

final class LinuxBSDFileLocator
implements FileLocator {
    private final ArgumentsBuilder argumentsBuilder;

    @Inject
    LinuxBSDFileLocator(ArgumentsBuilder argumentsBuilder) {
        this.argumentsBuilder = Objects.requireNonNull(argumentsBuilder);
    }

    @Override
    public Process locateFile(String filePath) throws IOException {
        this.argumentsBuilder.append("nautilus");
        this.argumentsBuilder.appendIfValueDefined("--browser", new File(filePath).getParent());
        return new ProcessBuilder(this.argumentsBuilder.getArgumentList()).start();
    }
}

